------------------------------------------------------------------ 
-- 
-- After synthesis has been performed, the boundary of the a VHDL 
-- design will contain single binary nodes (of type std_logic).
-- This VHDL description does instantiate the synthesized design,
-- while maintaining the original boundary decription (port types, 
-- modes, etc.) on the entity. 
-- 
-- The test patterns that run on the original VHDL description will 
-- run on this design, when it is loaded into a VHDL simulator 
-- together with a VHDL description of the synthesized design cpu
--
-- Since the synthesized design will have the same name as the
-- original design, store the synthesized design into a library
-- called SYNTHESIS. This way, there will be no name collision
-- between the original design and the synthesized design.
-- 
-- A VHDL description of the synthesized design can be generated 
-- by running -target=behav (behavioral) or any target technology 
-- (structural) with vhdl as the target format, or by using
-- VHDL back-annotated designs from place an route tools. The wrapper
-- will translate the binary ports of the synthesized design back to
-- their original VHDL types and modes.
-- 
------------------------------------------------------------------ 

library IEEE ;
use IEEE.STD_LOGIC_1164.all ;

-- Package typetran is in the $EXEMPLAR/data/typetran.vhd file
-- It contains type transformation functions between boundary types 
-- and std_logic
library EXEMPLAR ;
use EXEMPLAR.TYPETRAN.all ;

library SYNTHESIS ;
library ieee ;
use ieee.std_logic_1164.all ;
use work.cpu_lib.all ;

architecture rtl_SYNTHESIS of cpu is
    -- Declaration of the synthesized component
    component cpu 
        port (
             clock : IN STD_LOGIC ;
             reset : IN STD_LOGIC ;
             ready : IN STD_LOGIC ;
             addr_31, addr_30, addr_29, addr_28, addr_27,
             addr_26, addr_25, addr_24, addr_23, addr_22,
             addr_21, addr_20, addr_19, addr_18, addr_17,
             addr_16, addr_15, addr_14, addr_13, addr_12,
             addr_11, addr_10, addr_9, addr_8, addr_7,
             addr_6, addr_5, addr_4, addr_3, addr_2,
             addr_1, addr_0 : OUT STD_LOGIC ;
             rw : OUT STD_LOGIC ;
             vma : OUT STD_LOGIC ;
             data_31, data_30, data_29, data_28, data_27,
             data_26, data_25, data_24, data_23, data_22,
             data_21, data_20, data_19, data_18, data_17,
             data_16, data_15, data_14, data_13, data_12,
             data_11, data_10, data_9, data_8, data_7,
             data_6, data_5, data_4, data_3, data_2,
             data_1, data_0 : INOUT STD_LOGIC
        ) ;
    end component ;


    -- Intermediate signal declarations
    for l : cpu use entity SYNTHESIS.cpu ;
begin
    -- Instantiation of the synthesized component
    l : cpu port map (
            clock=>clock, 
            reset=>reset, 
            ready=>ready, 
            addr_31=>addr(31), addr_30=>addr(30), addr_29=>addr(29), 
            addr_28=>addr(28), addr_27=>addr(27), addr_26=>addr(26), 
            addr_25=>addr(25), addr_24=>addr(24), addr_23=>addr(23), 
            addr_22=>addr(22), addr_21=>addr(21), addr_20=>addr(20), 
            addr_19=>addr(19), addr_18=>addr(18), addr_17=>addr(17), 
            addr_16=>addr(16), addr_15=>addr(15), addr_14=>addr(14), 
            addr_13=>addr(13), addr_12=>addr(12), addr_11=>addr(11), 
            addr_10=>addr(10), addr_9=>addr(9), addr_8=>addr(8), 
            addr_7=>addr(7), addr_6=>addr(6), addr_5=>addr(5), 
            addr_4=>addr(4), addr_3=>addr(3), addr_2=>addr(2), 
            addr_1=>addr(1), addr_0=>addr(0), 
            rw=>rw, 
            vma=>vma, 
            data_31=>data(31), data_30=>data(30), data_29=>data(29), 
            data_28=>data(28), data_27=>data(27), data_26=>data(26), 
            data_25=>data(25), data_24=>data(24), data_23=>data(23), 
            data_22=>data(22), data_21=>data(21), data_20=>data(20), 
            data_19=>data(19), data_18=>data(18), data_17=>data(17), 
            data_16=>data(16), data_15=>data(15), data_14=>data(14), 
            data_13=>data(13), data_12=>data(12), data_11=>data(11), 
            data_10=>data(10), data_9=>data(9), data_8=>data(8), 
            data_7=>data(7), data_6=>data(6), data_5=>data(5), 
            data_4=>data(4), data_3=>data(3), data_2=>data(2), 
            data_1=>data(1), data_0=>data(0)) ;

   -- Intermediate signal assignments

end rtl_SYNTHESIS ;

